/**************************************************
 *  i2c_LCD library  (for AQM0802A)               *
 **************************************************/

#include "mcc_generated_files/mcc.h"
#include "mcc_generated_files/examples/i2c1_master_example.h"

#define I2C_WBR(a,b,c) (I2C1_Write1ByteRegister((a),(b),(c)))

#define AQM0802A    0x3e
#define VCC         50

#if   VCC == 50
    #define CONTRAST  0x18      // for 5.0V
    #define BOOST     0x00      // for 5.0V Bon=off
#elif VCC == 33
    #define CONTRAST  0x30      // for 3.3V
    #define BOOST     0x04      // for 3.3V Bon=on
#endif

//-------- send data ----------------------------
void LCD_dat(char chr){
    I2C1_Write1ByteRegister(AQM0802A, 0x40, chr);
//    I2C_WBR(AQM0802A, 0x40, chr);
    __delay_us(30); // 30us
}

//-------- send command -------------------------
void LCD_cmd(char cmd){
    I2C1_Write1ByteRegister(AQM0802A, 0x00, cmd);
//    I2C_WBR(AQM0802A, 0x00, cmd);
    if(cmd & 0xFC)              // bit6 = 1
        __delay_us(30);         // 30us
    else
        __delay_ms(2);          // 2ms Clear or Home
}

//-------- clear LCD--------------------------------
void LCD_clr(void){
    LCD_cmd(0x01);
}

//--------- Home -----------------------------------
void LCD_home(void){
    LCD_cmd(0x02);
}

//--------- Cursor X,Y -----------------------------
void LCD_cursor(int x, int y){
    if (y == 0)
        LCD_cmd((char)(0x80 + x));
    else if (y == 1)
        LCD_cmd((char)(0xc0 + x));
}

//-------- display strings -------------------------
void LCD_str(char *str){
    while(*str)
 	  LCD_dat(*str++);            //pointer increment
}

//-------- write 1 character to LCD ----------------
/*void putch(char ch){
    LCD_dat(ch);
}*/

//-------- LCD initialize ---------------------------
void LCD_init(){
    __delay_ms(40);             // 40ms wait
    LCD_cmd(0x38);              // 8bit,2line
    LCD_cmd(0x39);              // IS=1 : extention mode set
    LCD_cmd(0x14);              // Internal OSC Frequency
    LCD_cmd(0x70 
         + (CONTRAST & 0x0F));  // Contrast set
    LCD_cmd(0x58 + BOOST 
         + (CONTRAST >> 4));    // Power/ICON/Contrast Control
    LCD_cmd(0x6C);              // Follower control
    __delay_ms(200);            // 200ms wait
    LCD_cmd(0x38);              // IS=0 : extention mode cancel
    LCD_cmd(0x0C);              // Display ON
    LCD_cmd(0x01);              // Clear Display
    __delay_ms(2);              // wait more than 1.08ms
}
