
/*
̃CúA
GitHub"CAN_BUS_Shield-master(https://github.com/Seeed-Studio/CAN_BUS_Shield)"
ArduinopPICpɈڐAłB
AASPIhCo"skSPIlib"g܂B
*/
/*******************************************************************************
*  skMCP25xx.c - MCP2515/25625p֐Cu                                 *
*                                                                              *
*    mcp_begin           - mcp2515/25625̏s܂B                   *
*    mcp_init_Mask       - }XNWX^̏s܂B                  *
*    mcp_init_Filt       - tB^WX^̏s܂B                *
*    mcp_sendMsgBuf      - bZ[Wf[^𑗐M܂B                      *
*    mcp_readMsgBuf      - MbZ[Wf[^ǂݍ݂܂B            *
*    mcp_checkReceive    - M(RX0IF/RX1IF)Ă邩ׂ܂B               *
*    mcp_checkError      - G[tOWX^(EFLG)ǂݍ݂܂B          *
*    mcp_getCanId        - MʎqID𓾂鎖o܂B                *
*    mcp_isRemoteRequest - MbZ[Wf[^[gt[ׂ܂*
*    mcp_isExtendedFrame - MbZ[Wf[^gt[ׂ܂B  *
*    mcp_reset           - foCXZbg܂B                          *
*                                                                              *
*    F__delay_us() and __delay_ms() gpĂ̂ "skMCP25xx.h"    *
*         "#define _XTAL_FREQ 32000000""#define FCY 60000000"LqĂ*
*         32MHzȊOCPUNbNɂl͏܂傤B                   *
*         CvO"skSPIlib.c"SPI_Init()R[Ďgp       *
* ============================================================================ *
*  VERSION DATE        BY                    CHANGE/COMMENT                    *
* ---------------------------------------------------------------------------- *
*  1.00    2018-12-15  ޒH[(ނ)  Create                            *
* ============================================================================ *
*  PIC 16F1xxx 18F1xxx 18FxxK22 (SPIL8Kwordȏ̃e)              *
*  MPLAB X(v4.10)                                                              *
*  MPLAB(R) XC8 C Compiler Version 1.40                                        *
*******************************************************************************/
//#include <xc.h>
//#include "skSPIlib.h"
#include "mcp_can_dfs.h"
#include "skMCP25xx.h"
//#include "i2c_SSD1306.h"
#include "mcc_generated_files/spi.h"
#include "myProject.h"


volatile uint32_t  can_id ;        // CANʎqID
volatile uint8_t   ext_flg ;       // 0 =Wt[A  1 =gt[
volatile uint8_t   rtr ;           // 0 =f[^t[A1 =[gt[


/*********************************************************************************************************
** Function name:           txStatusPendingFlag
** Descriptions:            Mobt@䃌WX^̃bZ[WMvrbge
** Return Values:           "ԓǂݍ݃R}h"瓾̂ł̃rbgʒuԂ
**                          [ ][TX2REQ][ ][TX1REQ][ ][TX0REQ][ ][ ]
*********************************************************************************************************/
uint8_t txStatusPendingFlag(uint8_t i) {
     switch (i) {
        case 0: return MCP_STAT_TX0_PENDING ;     // 0x04
        case 1: return MCP_STAT_TX1_PENDING ;     // 0x10
        case 2: return MCP_STAT_TX2_PENDING ;     // 0x40
     }
     return 0xff ;
}
/*********************************************************************************************************
** Function name:           txCtrlReg
** Descriptions:            Mobt@CfbNXɏ]āAMobt@䃌WX^̃AhXԂ܂B
*********************************************************************************************************/
uint8_t txCtrlReg(uint8_t i) {
     switch (i) {
        case 0: return MCP_TXB0CTRL ;
        case 1: return MCP_TXB1CTRL ;
        case 2: return MCP_TXB2CTRL ;
     }
     return MCP_TXB2CTRL ;
}
/*********************************************************************************************************
** Function name:           txIfFlag
** Descriptions:            CANINTFWX^̑M荞݃tOrbgʒuԂ܂B
**                          [ ][ ][ ][TX2IF][TX1IF][TX0IF][ ][ ]
*********************************************************************************************************/
uint8_t txIfFlag(uint8_t i) {
     switch (i) {
        case 0: return MCP_TX0IF ;      // 0x04
        case 1: return MCP_TX1IF ;      // 0x08
        case 2: return MCP_TX2IF ;      // 0x10
     }
     return 0;
}
/*********************************************************************************************************
** Function name:           txSidhToTxLoad
** Descriptions:            Mobt@WX^̐擪AhXɏ]"Mobt@ւ̏ݗvR}h"Ԃ܂B
*********************************************************************************************************/
uint8_t txSidhToTxLoad(uint8_t sidh) {
     switch (sidh) {
        case MCP_TXB0SIDH: return MCP_LOAD_TX0 ;
        case MCP_TXB1SIDH: return MCP_LOAD_TX1 ;
        case MCP_TXB2SIDH: return MCP_LOAD_TX2 ;
     }
     return 0;
}
/*********************************************************************************************************
** Function name:           txSidhToRTS
** Descriptions:            Mobt@WX^̐擪AhXɏ]"MvR}h"Ԃ܂B
*********************************************************************************************************/
uint8_t txSidhToRTS(uint8_t sidh) {
     switch (sidh) {
        case MCP_TXB0SIDH: return MCP_RTS_TX0 ;
        case MCP_TXB1SIDH: return MCP_RTS_TX1 ;
        case MCP_TXB2SIDH: return MCP_RTS_TX2 ;
     }
     return 0;
}
/*********************************************************************************************************
** Function name:           mcp_begin
** Descriptions:            mcp2515/25625̏s܂B
** Parameters:   speedset - CANoX̒ʐMxw肷
**               clockset - foCX̃NbNw肷(8/16/20MHz)
** Return Values:
**                 CAN_OK - I
**           CAN_FAILINIT - s
*********************************************************************************************************/
uint8_t mcp_begin(uint8_t speedset, uint8_t clockset)
{
     uint8_t ret ;

     MCP25XX_UNSELECT() ;     // SPICSHIGHɃZbg
     // mcp2515/25625̏
     ret = mcp25xx_init(speedset, clockset) ;
     return ((ret == MCP25XX_OK) ? CAN_OK : CAN_FAILINIT) ;
}
/*********************************************************************************************************
** Function name:           mcp25xx_init
** Descriptions:            foCX̏s܂B
*********************************************************************************************************/
uint8_t mcp25xx_init(const uint8_t canSpeed, const uint8_t clock)
{

     uint8_t res ;

//		 __delay_ms(100);
     mcp_reset() ;            // foCX̃Zbgs

     // RtBO[hɂ܂B
     res = mcp25xx_setCANCTRL_Mode(MODE_CONFIG);
     if (res > 0) {
          __delay_ms(10) ;
          return res ;        // [hύXs
     }
     __delay_ms(10) ;

     // CANʐMx̐ݒs܂B
     if (mcp25xx_configRate(canSpeed, clock)) {
          __delay_ms(10) ;
          return res ;        // CANʐMx̐ݒ莸s
     }
     __delay_ms(10) ;

     if ( res == MCP25XX_OK ) {
          // Mobt@̃NAs܂B
          mcp25xx_initCANBuffers() ;
          // 荞ݏ̐ݒs܂B(Mobt@OƂP̊荞݂LƂ)
          mcp25xx_setRegister(MCP_CANINTE, MCP_RX0IF | MCP_RX1IF) ;
          // W/gʎqtB^ɈvSẴbZ[WM
          // RXB0tȂRXB1ɐ؂ւď
          mcp25xx_modifyRegister(MCP_RXB0CTRL,
                                 MCP_RXB_RX_MASK | MCP_RXB_BUKT_MASK,
                                 MCP_RXB_RX_STDEXT | MCP_RXB_BUKT_MASK) ;
          mcp25xx_modifyRegister(MCP_RXB1CTRL, MCP_RXB_RX_MASK,
                                 MCP_RXB_RX_STDEXT) ;

/*          mcp25xx_modifyRegister(MCP_RXB0CTRL,
                                 MCP_RXB_RX_MASK | MCP_RXB_BUKT_MASK,
                                 MCP_RXB_RX_ANY | MCP_RXB_BUKT_MASK) ;
          mcp25xx_modifyRegister(MCP_RXB1CTRL, MCP_RXB_RX_MASK,
                                 MCP_RXB_RX_ANY) ;*/
          // ʏ탂[hɐݒ肵܂B
          res = mcp25xx_setCANCTRL_Mode(MODE_NORMAL) ;
          __delay_ms(10) ;
          if (res) {
               return res ;        // [hύXs
          }
     }

     return res ; 
}
/*********************************************************************************************************
** Function name:           mcp25xx_initCANBuffers
** Descriptions:            Mobt@(TXBnCTRL-TXBnD7)ƎM䃌WX^̃NAs܂B
*********************************************************************************************************/
void mcp25xx_initCANBuffers(void)
{
     uint8_t i, a1, a2, a3 ;

     // Mobt@䃌WX^ƑMobt@WX^
     a1 = MCP_TXB0CTRL ;
     a2 = MCP_TXB1CTRL ;
     a3 = MCP_TXB2CTRL ;
     for (i = 0 ; i < 14 ; i++) {
          mcp25xx_setRegister(a1, 0) ;
          mcp25xx_setRegister(a2, 0) ;
          mcp25xx_setRegister(a3, 0) ;
          a1++ ;
          a2++ ;
          a3++ ;
     }
     // Mobt@䃌WX^
     mcp25xx_setRegister(MCP_RXB0CTRL, 0) ;
     mcp25xx_setRegister(MCP_RXB1CTRL, 0) ;
}

/*********************************************************************************************************
** Function name:           mcp25xx_configRate
** Descriptions:            CANʐMx̐ݒs܂B(foCX8/16/20MHzNbN̂ݑΉ)
*********************************************************************************************************/
uint8_t mcp25xx_configRate(const uint8_t canSpeed, const uint8_t clock)
{
     uint8_t set, cfg1, cfg2, cfg3 ;

     set = 1;
     switch (clock) {
        case (MCP_20MHz):
        switch (canSpeed) 
        {
            case (CAN_40KBPS):          //  40Kbps
                cfg1 = MCP_20MHz_40kBPS_CFG1;
                cfg2 = MCP_20MHz_40kBPS_CFG2;
                cfg3 = MCP_20MHz_40kBPS_CFG3;
                break;

            case (CAN_50KBPS):          //  50Kbps
                cfg1 = MCP_20MHz_50kBPS_CFG1;
                cfg2 = MCP_20MHz_50kBPS_CFG2;
                cfg3 = MCP_20MHz_50kBPS_CFG3;
                break;

            case (CAN_80KBPS):          //  80Kbps
                cfg1 = MCP_20MHz_80kBPS_CFG1;
                cfg2 = MCP_20MHz_80kBPS_CFG2;
                cfg3 = MCP_20MHz_80kBPS_CFG3;
                break;

            case (CAN_100KBPS):         // 100Kbps
                cfg1 = MCP_20MHz_100kBPS_CFG1;
                cfg2 = MCP_20MHz_100kBPS_CFG2;
                cfg3 = MCP_20MHz_100kBPS_CFG3;
                break;

            case (CAN_125KBPS):         // 125Kbps
                cfg1 = MCP_20MHz_125kBPS_CFG1;
                cfg2 = MCP_20MHz_125kBPS_CFG2;
                cfg3 = MCP_20MHz_125kBPS_CFG3;
                break;

            case (CAN_200KBPS):         // 200Kbps
                cfg1 = MCP_20MHz_200kBPS_CFG1;
                cfg2 = MCP_20MHz_200kBPS_CFG2;
                cfg3 = MCP_20MHz_200kBPS_CFG3;
                break;

            case (CAN_250KBPS):         // 250Kbps
                cfg1 = MCP_20MHz_250kBPS_CFG1;
                cfg2 = MCP_20MHz_250kBPS_CFG2;
                cfg3 = MCP_20MHz_250kBPS_CFG3;
                break;

            case (CAN_500KBPS):         // 500Kbps
                cfg1 = MCP_20MHz_500kBPS_CFG1;
                cfg2 = MCP_20MHz_500kBPS_CFG2;
                cfg3 = MCP_20MHz_500kBPS_CFG3;
                break;
        
            case (CAN_1000KBPS):        //   1Mbps
                cfg1 = MCP_20MHz_1000kBPS_CFG1;
                cfg2 = MCP_20MHz_1000kBPS_CFG2;
                cfg3 = MCP_20MHz_1000kBPS_CFG3;
                break;  

            default:
                set = 0;
            break;
        }
        break;

        case (MCP_16MHz):
        switch (canSpeed) 
        {
            case (CAN_5KBPS):           //   5Kbps
                cfg1 = MCP_16MHz_5kBPS_CFG1;
                cfg2 = MCP_16MHz_5kBPS_CFG2;
                cfg3 = MCP_16MHz_5kBPS_CFG3;
                break;

            case (CAN_10KBPS):          //  10Kbps
                cfg1 = MCP_16MHz_10kBPS_CFG1;
                cfg2 = MCP_16MHz_10kBPS_CFG2;
                cfg3 = MCP_16MHz_10kBPS_CFG3;
                break;

            case (CAN_20KBPS):          //  20Kbps
                cfg1 = MCP_16MHz_20kBPS_CFG1;
                cfg2 = MCP_16MHz_20kBPS_CFG2;
                cfg3 = MCP_16MHz_20kBPS_CFG3;
                break;

            case (CAN_40KBPS):          //  40Kbps
                cfg1 = MCP_16MHz_40kBPS_CFG1;
                cfg2 = MCP_16MHz_40kBPS_CFG2;
                cfg3 = MCP_16MHz_40kBPS_CFG3;
                break;

            case (CAN_50KBPS):          //  50Kbps
                cfg1 = MCP_16MHz_50kBPS_CFG1;
                cfg2 = MCP_16MHz_50kBPS_CFG2;
                cfg3 = MCP_16MHz_50kBPS_CFG3;
                break;

            case (CAN_80KBPS):          //  80Kbps
                cfg1 = MCP_16MHz_80kBPS_CFG1;
                cfg2 = MCP_16MHz_80kBPS_CFG2;
                cfg3 = MCP_16MHz_80kBPS_CFG3;
                break;

            case (CAN_100KBPS):         // 100Kbps
                cfg1 = MCP_16MHz_100kBPS_CFG1;
                cfg2 = MCP_16MHz_100kBPS_CFG2;
                cfg3 = MCP_16MHz_100kBPS_CFG3;
                break;

            case (CAN_125KBPS):         // 125Kbps
                cfg1 = MCP_16MHz_125kBPS_CFG1;
                cfg2 = MCP_16MHz_125kBPS_CFG2;
                cfg3 = MCP_16MHz_125kBPS_CFG3;
                break;

            case (CAN_200KBPS):         // 200Kbps
                cfg1 = MCP_16MHz_200kBPS_CFG1;
                cfg2 = MCP_16MHz_200kBPS_CFG2;
                cfg3 = MCP_16MHz_200kBPS_CFG3;
                break;

            case (CAN_250KBPS):         // 250Kbps
                cfg1 = MCP_16MHz_250kBPS_CFG1;
                cfg2 = MCP_16MHz_250kBPS_CFG2;
                cfg3 = MCP_16MHz_250kBPS_CFG3;
                break;

            case (CAN_500KBPS):         // 500Kbps
                cfg1 = MCP_16MHz_500kBPS_CFG1;
                cfg2 = MCP_16MHz_500kBPS_CFG2;
                cfg3 = MCP_16MHz_500kBPS_CFG3;
                break;
        
            case (CAN_1000KBPS):        //   1Mbps
                cfg1 = MCP_16MHz_1000kBPS_CFG1;
                cfg2 = MCP_16MHz_1000kBPS_CFG2;
                cfg3 = MCP_16MHz_1000kBPS_CFG3;
                break;  

            default:
                set = 0;
                break;
        }
        break;

        case (MCP_8MHz):
        switch (canSpeed) 
        {
            case (CAN_5KBPS):           //   5KBPS                  
                cfg1 = MCP_8MHz_5kBPS_CFG1;
                cfg2 = MCP_8MHz_5kBPS_CFG2;
                cfg3 = MCP_8MHz_5kBPS_CFG3;
                break;

            case (CAN_10KBPS):          //  10KBPS                  
                cfg1 = MCP_8MHz_10kBPS_CFG1;
                cfg2 = MCP_8MHz_10kBPS_CFG2;
                cfg3 = MCP_8MHz_10kBPS_CFG3;
                break;

            case (CAN_20KBPS):          //  20KBPS                  
                cfg1 = MCP_8MHz_20kBPS_CFG1;
                cfg2 = MCP_8MHz_20kBPS_CFG2;
                cfg3 = MCP_8MHz_20kBPS_CFG3;
                break;

            case (CAN_40KBPS):          //  40Kbps
                cfg1 = MCP_8MHz_40kBPS_CFG1;
                cfg2 = MCP_8MHz_40kBPS_CFG2;
                cfg3 = MCP_8MHz_40kBPS_CFG3;
                break;

            case (CAN_50KBPS):          //  50Kbps
                cfg1 = MCP_8MHz_50kBPS_CFG1;
                cfg2 = MCP_8MHz_50kBPS_CFG2;
                cfg3 = MCP_8MHz_50kBPS_CFG3;
                break;

            case (CAN_80KBPS):          //  80Kbps
                cfg1 = MCP_8MHz_80kBPS_CFG1;
                cfg2 = MCP_8MHz_80kBPS_CFG2;
                cfg3 = MCP_8MHz_80kBPS_CFG3;
                break;

            case (CAN_100KBPS):         // 100Kbps
                cfg1 = MCP_8MHz_100kBPS_CFG1;
                cfg2 = MCP_8MHz_100kBPS_CFG2;
                cfg3 = MCP_8MHz_100kBPS_CFG3;
                break;

            case (CAN_125KBPS):         // 125Kbps
                cfg1 = MCP_8MHz_125kBPS_CFG1;
                cfg2 = MCP_8MHz_125kBPS_CFG2;
                cfg3 = MCP_8MHz_125kBPS_CFG3;
                break;

            case (CAN_200KBPS):         // 200Kbps
                cfg1 = MCP_8MHz_200kBPS_CFG1;
                cfg2 = MCP_8MHz_200kBPS_CFG2;
                cfg3 = MCP_8MHz_200kBPS_CFG3;
                break;

            case (CAN_250KBPS):         // 250Kbps
                cfg1 = MCP_8MHz_250kBPS_CFG1;
                cfg2 = MCP_8MHz_250kBPS_CFG2;
                cfg3 = MCP_8MHz_250kBPS_CFG3;
                break;

            case (CAN_500KBPS):         // 500Kbps
                cfg1 = MCP_8MHz_500kBPS_CFG1;
                cfg2 = MCP_8MHz_500kBPS_CFG2;
                cfg3 = MCP_8MHz_500kBPS_CFG3;
                break;
        
            case (CAN_1000KBPS):        //   1Mbps
                cfg1 = MCP_8MHz_1000kBPS_CFG1;
                cfg2 = MCP_8MHz_1000kBPS_CFG2;
                cfg3 = MCP_8MHz_1000kBPS_CFG3;
                break;  

            default:
                set = 0;
                break;
        }
        break;

        default:
        set = 0;
        break;
     }

     if (set) {
          mcp25xx_setRegister(MCP_CNF1, cfg1);
          mcp25xx_setRegister(MCP_CNF2, cfg2);
          mcp25xx_setRegister(MCP_CNF3, cfg3);
          return MCP25XX_OK;
     } else {
          return MCP25XX_FAIL;
     }
}
/*********************************************************************************************************
** Function name:           mcp_sendMsgBuf
** Descriptions:            bZ[Wf[^𑗐M܂B
** Parameters: 
**                     id - ʎqID(HEXŎw肷
**                    ext - 0=WtH[}bg  1=gtH[}bg
**                 rtrBit - 0=f[^t[    1=[gt[
**                    len - Mf[^̒(0-8)
**                   *buf - Mf[^̊i[AhXݒ肷(Mf[^MAX8byte)
**              wait_sent - 1=MI܂ő҂  0=҂Ȃ
** Return Values:
**     CAN_GETTXBFTIMEOUT - 500msoĂMobt@ɋ󂫂Ȃ
**     CAN_SENDMSGTIMEOUT - 500msoĂf[^MȂ
**                 CAN_OK - MI
*********************************************************************************************************/
uint8_t mcp_sendMsgBuf(uint32_t id, uint8_t ext, uint8_t rtrBit, uint8_t len, const uint8_t *buf, uint8_t wait_sent)
{
     uint8_t res, res1, txbuf_n ;
     uint16_t uiTimeOut = 0 ;

     can_id  = id ;
     ext_flg = ext ;
     rtr     = rtrBit ;

     // 3̑Mobt@̋󂫂T
     do {
          if (uiTimeOut > 0) __delay_us(10) ;
          // 󂫂L΂̃obt@TXBnSIDH̃AhX𓾂
          res = mcp25xx_getNextFreeTXBuf(&txbuf_n) ;
          uiTimeOut++ ;
     } while (res == MCP_ALLTXBUSY && (uiTimeOut < TIMEOUTVALUE)) ;

     if (uiTimeOut == TIMEOUTVALUE) {
          return CAN_GETTXBFTIMEOUT ;                  // Mobt@^CAEg(󂫂)
     }

    // bZ[Wf[^𑗐M܂B
    mcp25xx_write_canMsg(txbuf_n, id, ext, rtrBit, len, buf) ;

    if (wait_sent) {
         // MI܂ő҂
         uiTimeOut = 0; 
         do {
              if (uiTimeOut > 0) __delay_us(10) ;
               uiTimeOut++ ;
               // txbuf_n - 1 = TXBnCTRL
               res1 = mcp25xx_readRegister(txbuf_n - 1) ;   // Mobt@䃌WX^ǂݍ
               res1 = res1 & 0x08 ;                         // Mvrbg(TXREQ)o
         } while (res1 && (uiTimeOut < TIMEOUTVALUE)) ;

         if (uiTimeOut == TIMEOUTVALUE) {
              return CAN_SENDMSGTIMEOUT ;                   // MbZ[W^CAEg
         }
    }

    return CAN_OK ;
}
/*********************************************************************************************************
** Function name:           mcp25xx_getNextFreeTXBuf
** Descriptions:            Mׂ̈Ɏ̋󂫑Mobt@܂BȂꍇ́AMCP_ALLTXBUSYԂ܂B
**                          󂫂LΊY鑗Mobt@CANINTFݏNA
** Return Values:           󂫂L΂̃obt@TXBnSIDH̃AhX"txbuf_n"ɃZbg܂B
**          MCP_ALLTXBUSY - 󂫂
*********************************************************************************************************/
uint8_t mcp25xx_getNextFreeTXBuf(uint8_t *txbuf_n)
{
     uint8_t status=mcp25xx_readStatus() & MCP_STAT_TX_PENDING_MASK ; // "ԓǂݍ݃R}h"𔭍s
     uint8_t i ;

     *txbuf_n = 0x00 ;

     // "ԓǂݍ݃R}h"ŕԂ鑗Mobt@䃌WX^
     // bZ[WMvrbg(TX0REQ/TX1REQ/TX2REQ)𒲂ׂĂ
     if ( status == MCP_STAT_TX_PENDING_MASK ) return MCP_ALLTXBUSY ; // Sobt@M

     // \ς݈ȊO3̑Mobt@SĂ`FbN
     for (i = 0 ; i < MCP_N_TXBUFFERS ; i++) {
          if ( (status & txStatusPendingFlag(i) ) == 0 ) {
               *txbuf_n = txCtrlReg(i) + 1 ;           // Mobt@TXBnSIDH̃AhX𓾂
               mcp25xx_modifyRegister(MCP_CANINTF, txIfFlag(i), 0) ;  // Y݃rbgNA
               return MCP25XX_OK ;                     // 󂫗L
          }
     }

     return MCP_ALLTXBUSY ;                            // 󂫖
}
/*********************************************************************************************************
** Function name:           mcp25xx_write_canMsg
** Descriptions:            bZ[Wf[^݂̏s܂B
**                          ӁI ẼAhX̃`FbN͂܂I
** Parameters: 
**       buffer_sidh_addr - Mobt@TXBnSIDH̃AhX
**                     id - ʎqID(HEXŎw肷
**                    ext - 0=WtH[}bg  1=gtH[}bg
**                 rtrBit - 0=f[^t[    1=[gt[
**                    len - Mf[^̒(0-8)
**                   *buf - Mf[^̊i[AhXݒ肷(Mf[^MAX8byte)
*********************************************************************************************************/
void mcp25xx_write_canMsg(const uint8_t buffer_sidh_addr, uint32_t id, uint8_t ext, uint8_t rtrBit, uint8_t len, const uint8_t *buf)
{
     uint8_t load_addr=txSidhToTxLoad(buffer_sidh_addr) ;   // obt@݃R}h𓾂

     uint8_t tbufdata[4] ;
     uint8_t dlc = len | ( rtrBit ? MCP_RTR_MASK : 0 ) ;    // TXBnDLC̃f[^쐬
     uint8_t i ;

     // ʎqIDobt@f[^̍\tbufdataɃZbgB
     mcp25xx_id_to_buf(ext,id,tbufdata) ;

     MCP25XX_SELECT() ;
     SPI_transfer(load_addr) ;                              // obt@݃R}h̔s
     for (i = 0; i < 4; i++) SPI_transfer(tbufdata[i]) ;    // ʎqID̏
     SPI_transfer(dlc) ;                                    // f[^R[h̏
     for (i = 0; i < len && i<CAN_MAX_CHAR_IN_MESSAGE; i++) SPI_transfer(buf[i]) ;// f[^̏
     MCP25XX_UNSELECT() ;

     // bZ[WM̊Jn
     mcp25xx_start_transmit( buffer_sidh_addr );

}
/*********************************************************************************************************
** Function name:           mcp25xx_start_transmit
** Descriptions:            foCXɃbZ[WMJn܂B
** Parameters: 
**               mcp_addr - Mobt@TXBnSIDH̃AhX
*********************************************************************************************************/
void mcp25xx_start_transmit(const uint8_t mcp_addr)
{
     MCP25XX_SELECT() ;
     SPI_transfer(txSidhToRTS(mcp_addr)) ;  // MvR}h𔭍s
     MCP25XX_UNSELECT() ;
}
/*********************************************************************************************************
** Function name:           mcp25xx_id_to_buf
** Descriptions:            w肵ʎqIDobt@f[^̍\tbufdataɃZbgB
*********************************************************************************************************/
void mcp25xx_id_to_buf(const uint8_t ext, const uint32_t id, uint8_t *tbufdata)
{
     uint16_t canid ;

     canid = (uint16_t)(id & 0x0FFFF) ;

     if ( ext == 1 ) {
          // gʎqID
          tbufdata[MCP_EID0] = (uint8_t) (canid & 0xFF) ;
          tbufdata[MCP_EID8] = (uint8_t) (canid >> 8) ;
          canid = (uint16_t)(id >> 16) ;
          tbufdata[MCP_SIDL] = (uint8_t) (canid & 0x03) ;
          tbufdata[MCP_SIDL] += (uint8_t) ((canid & 0x1C) << 3) ;
          tbufdata[MCP_SIDL] |= MCP_TXB_EXIDE_M ;
          tbufdata[MCP_SIDH] = (uint8_t) (canid >> 5 ) ;
     } else {
          // WʎqID
          tbufdata[MCP_SIDH] = (uint8_t) (canid >> 3 ) ;
          tbufdata[MCP_SIDL] = (uint8_t) ((canid & 0x07 ) << 5) ;
          tbufdata[MCP_EID0] = 0 ;
          tbufdata[MCP_EID8] = 0 ;
     }
}
/*********************************************************************************************************
** Function name:           mcp25xx_write_id
** Descriptions:            ʎqIDWX^ɏ݂܂B
** Parameters: 
**               mcp_addr - obt@xxxnSIDH̃AhX
**                    ext - 0=WtH[}bg  1=gtH[}bg
**                     id - ʎqID(HEXŎw肷
*********************************************************************************************************/
void mcp25xx_write_id(const uint8_t mcp_addr, const uint8_t ext, const uint32_t id)
{
     uint8_t tbufdata[4] ;

     mcp25xx_id_to_buf(ext,id,tbufdata) ;
     mcp25xx_setRegisterS(mcp_addr, tbufdata, 4) ;
}
/*********************************************************************************************************
** Function name:           mcp_init_Mask
** Descriptions:            }XNWX^̏s܂B
** Parameters:        num - }XNWX^̔ԍ(0-1)
**                    ext - 0=WtH[}bg  1=gtH[}bg
**                 ulData - }XNɐݒ肷f[^
** Return Values:
**             MCP25XX_OK - I
**           MCP25XX_FAIL - s
*********************************************************************************************************/
uint8_t mcp_init_Mask(uint8_t num, uint8_t ext, uint32_t ulData)
{
     uint8_t res = MCP25XX_OK ;

     __delay_ms(10) ;
     res = mcp25xx_setCANCTRL_Mode(MODE_CONFIG) ;           // RtBO[hɂ
     if (res > 0) {
          __delay_ms(10) ;
          return res ;
     }

     if (num == 0) {
          mcp25xx_write_id(MCP_RXM0SIDH, ext, ulData) ;     // }XN0ɐݒ
     } else if (num == 1) {
          mcp25xx_write_id(MCP_RXM1SIDH, ext, ulData) ;     // }XN1ɐݒ
     } else {
          // }XNWX^̔ԍwG[
          res =  MCP25XX_FAIL ;
          mcp25xx_setCANCTRL_Mode(MODE_NORMAL) ;            // ʏ탂[hɂ
          __delay_ms(10) ;
          return res ;
     }

     res = mcp25xx_setCANCTRL_Mode(MODE_NORMAL) ;           // ʏ탂[hɂ
     __delay_ms(10) ;
     return res ;
}
/*********************************************************************************************************
** Function name:           mcp_init_Filt
** Descriptions:            tB^WX^̏s܂B
** Parameters:        num - tB^WX^̔ԍ(0-5)
**                    ext - 0=WtH[}bg  1=gtH[}bg
**                 ulData - tB^ɐݒ肷f[^
** Return Values:
**             MCP25XX_OK - I
**           MCP25XX_FAIL - s
*********************************************************************************************************/
uint8_t mcp_init_Filt(uint8_t num, uint8_t ext, uint32_t ulData)
{
     uint8_t res = MCP25XX_OK ;

     __delay_ms(10) ;
     res = mcp25xx_setCANCTRL_Mode(MODE_CONFIG) ; // RtBO[hɂ
     if (res > 0) {
         __delay_ms(10) ;
         return res ;
     }

     switch ( num ) {
       case 0:
         mcp25xx_write_id(MCP_RXF0SIDH, ext, ulData) ;      // tB^0ɐݒ
         break;
       case 1:
         mcp25xx_write_id(MCP_RXF1SIDH, ext, ulData) ;      // tB^1ɐݒ
         break;
       case 2:
         mcp25xx_write_id(MCP_RXF2SIDH, ext, ulData) ;      // tB^2ɐݒ
         break;
       case 3:
         mcp25xx_write_id(MCP_RXF3SIDH, ext, ulData) ;      // tB^3ɐݒ
         break;
       case 4:
         mcp25xx_write_id(MCP_RXF4SIDH, ext, ulData) ;      // tB^4ɐݒ
         break;
       case 5:
         mcp25xx_write_id(MCP_RXF5SIDH, ext, ulData) ;      // tB^5ɐݒ
         break;
       default:
         // tB^WX^̔ԍwG[
         res = MCP25XX_FAIL ;
         mcp25xx_setCANCTRL_Mode(MODE_NORMAL) ;   // ʏ탂[hɂ
         __delay_ms(10) ;
         return res ;
     }

     res = mcp25xx_setCANCTRL_Mode(MODE_NORMAL) ; // ʏ탂[hɂ
     __delay_ms(10) ;
     return res ;
}
/*********************************************************************************************************
** Function name:           mcp_readMsgBuf
** Descriptions:            MbZ[Wf[^ǂݍ݂܂B
**                          ̑̏́AgetCanId()/isRemoteRequest()/isExtendedFrame()Œׂ܂B
** Parameters:
**                   *len - Mf[^̒(0-8)Ԃ
**                   *buf - Mf[^̊i[AhXݒ肷(Mf[^MAX8byte)
** Return Values:
**              CAN_NOMSG - MbZ[W͖
**                 CAN_OK - ɎM
*********************************************************************************************************/
uint8_t mcp_readMsgBuf(uint8_t *len, uint8_t buf[])
{
     // readRxTxStatus()CANINTF݃WX^ɕϊĕԂ܂B
     return readMsgBufID(readRxTxStatus(),&can_id,&ext_flg,&rtr,len,buf) ;
}
/*********************************************************************************************************
** Function name:           readMsgBufID
** Descriptions:            Xe[^XɉĎMobt@ǂݏoAbZ[Wǂݎ鎖o܂B
**                          Xe[^XreadRxTxStatus()œǂݎKv܂B
** Parameters:  status    - CANINTF݃WX^Zbg
**              *id       - MʎqIDԂ
**              *ext      - 0=WtH[}bg  1=gtH[}bg ̏Ԃ
**              *rtrBit   - 0=f[^t[    1=[gt[ ̏Ԃ
**              *len      - Mf[^̒(0-8)Ԃ
**              *buf      - Mf[^̊i[AhXݒ肷(Mf[^MAX8byte)
** Return Values:
**              CAN_NOMSG - MbZ[W͖
**              CAN_OK    - ɎM
*********************************************************************************************************/
uint8_t readMsgBufID(uint8_t status, volatile uint32_t *id, volatile uint8_t *ext, volatile uint8_t *rtrBit, volatile uint8_t *len, volatile uint8_t *buf)
{
     uint8_t rc ;

     rc = CAN_NOMSG ;
     if ( status & MCP_RX0IF ) {
          // Mobt@Oǂݍ
          mcp25xx_read_canMsg( MCP_READ_RX0, id, ext, rtrBit, len, buf) ;
          // M荞݃tONA
          mcp25xx_modifyRegister(MCP_CANINTF, MCP_RX0IF, 0) ;
          rc = CAN_OK ;
     } else if ( status & MCP_RX1IF ) {
          // Mobt@Pǂݍ
          mcp25xx_read_canMsg( MCP_READ_RX1, id, ext, rtrBit, len, buf) ;
          // M荞݃tONA
          mcp25xx_modifyRegister(MCP_CANINTF, MCP_RX1IF, 0) ;
          rc = CAN_OK ;
     }

     if (rc==CAN_OK) {
          rtr     = *rtrBit ;
          ext_flg = *ext ;
          can_id  = *id ;
     } else {
          *len = 0 ;
     }

     return rc ;
}
/*********************************************************************************************************
** Function name:           readRxTxStatus
** Descriptions:            RXTX荞݃rbgǂݏo܂B
**                          ֐"ԓǂݍ݃R}h"̃Xe[^Xgp܂AʂCANINTFтɕϊ܂B
**                          ɂASPIĂяoۑׂ1̌ĂяoŊ荞݂̏ԂmF鎖ł܂B
**                          eXgׂ̈checkClearRxStatuscheckClear TxStatusgp܂B
**                          
*********************************************************************************************************/
uint8_t readRxTxStatus(void)
{
     uint8_t ret ;

     // "ԓǂݍ݃R}h"ŏԂǂݎ
     ret = ( mcp25xx_readStatus() & ( MCP_STAT_TXIF_MASK | MCP_STAT_RXIF_MASK ) ) ;
     ret = (ret & MCP_STAT_TX0IF ? MCP_TX0IF : 0) |
           (ret & MCP_STAT_TX1IF ? MCP_TX1IF : 0) |
           (ret & MCP_STAT_TX2IF ? MCP_TX2IF : 0) |
           (ret & MCP_STAT_RXIF_MASK) ; // Rx bits happend to be same on status and MCP_CANINTF
     return ret ;
}
/*********************************************************************************************************
** Function name:           mcpxx_read_canMsg
** Descriptions:            bZ[Wf[^̓ǂݍ݂s܂B
*********************************************************************************************************/
void mcp25xx_read_canMsg( const uint8_t buffer_load_addr, volatile uint32_t *id, volatile uint8_t *ext, volatile uint8_t *rtrBit, volatile uint8_t *len, volatile uint8_t *buf)
{
     uint8_t tbufdata[4] ;
     uint8_t i ;

     MCP25XX_SELECT() ;

     SPI_transfer(buffer_load_addr) ;   // "RXobt@ǂݍ"R}h𔭍s
     // mcp2515ɂ̓AhX|C^̎CNg܂B
     // RXBnSIDHWX^4oCgǂݍ
     for (i = 0; i < 4; i++) tbufdata[i] = SPI_transfer(0x00) ;  // ʎqIDǂݍ

     *id = (uint32_t )((tbufdata[MCP_SIDH] << 3) + (tbufdata[MCP_SIDL] >> 5) );
     *ext = 0 ;
     if ( (tbufdata[MCP_SIDL] & MCP_TXB_EXIDE_M) ==  MCP_TXB_EXIDE_M ) {
          // gʎqIDȂ珈
          *id = (*id << 2) + (tbufdata[MCP_SIDL] & 0x03) ;
          *id = (*id << 8) + tbufdata[MCP_EID8] ;
          *id = (*id << 8) + tbufdata[MCP_EID0] ;
          *ext = 1 ;
     }

     uint8_t pMsgSize = SPI_transfer(0x00) ;           // f[^R[hǂݍ
     *len = pMsgSize & MCP_DLC_MASK ;                  // f[^
     *rtrBit = (pMsgSize & MCP_RTR_MASK) ? 1 : 0 ;     // [gt[rbg
     for (i = 0 ; i < *len && i<CAN_MAX_CHAR_IN_MESSAGE ; i++) {
          buf[i] = SPI_transfer(0x00) ;                // f[^ǂݍ
     }

     MCP25XX_UNSELECT() ;
}
/*********************************************************************************************************
** Function name:           mcp_checkReceive
** Descriptions:            "ԓǂݍ݃R}h"œǂݍ񂾓eAM(RX0IF/RX1IF)Ă邩ׂ܂B
** Parameters:              
** Return Values:
**           CAN_MSGAVAIL - bZ[WMĂ܂
**           CAN_NOMSG    - bZ[WMĂȂ
*********************************************************************************************************/
uint8_t mcp_checkReceive(void)
{
    uint8_t res ;

    res = mcp25xx_readStatus() ;                             // "ԓǂݍ݃R}h"̔s
    return ((res & MCP_STAT_RXIF_MASK)?CAN_MSGAVAIL:CAN_NOMSG) ;
}
/*********************************************************************************************************
** Function name:           mcp_checkError
** Descriptions:            G[tOWX^(EFLG)ǂݍ݂܂B
** Parameters:              
** Return Values:
**          CAN_CTRLERROR - G[L
**                 CAN_OK - G[
*********************************************************************************************************/
uint8_t mcp_checkError(void)
{
    uint8_t eflg ;

    eflg = mcp25xx_readRegister(MCP_EFLG) ;
    return ((eflg & MCP_EFLG_ERRORMASK) ? CAN_CTRLERROR : CAN_OK) ;
}
/*********************************************************************************************************
** Function name:           mcp_getCanId
** Descriptions:            MAȂ͎ʎqID𓾂鎖o܂B
*********************************************************************************************************/
uint32_t mcp_getCanId(void)
{
    return can_id ;
}
/*********************************************************************************************************
** Function name:           mcp_isRemoteRequest
** Descriptions:            MAꂪ[gt[ǂmF鎖o܂B
** Return Values:           0 =f[^t[A1 =[gt[
*********************************************************************************************************/
uint8_t mcp_isRemoteRequest(void)
{
    return rtr ;
}
/*********************************************************************************************************
** Function name:           mcp_isExtendedFrame
** Descriptions:            W11rbgt[͊g29rbgM܂H 
** Return Values:           0 = WA1 = g
*********************************************************************************************************/
uint8_t mcp_isExtendedFrame(void)
{
    return ext_flg ;
}
/*********************************************************************************************************
** Function name:           mcp25xx_readStatus
** Descriptions:            "ԓǂݍ"R}h𔭍s܂B
** Parameters:              
** Return Values:           ݂̏ԂԂ
**                          [TX2IF][TX2REQ][TX1IF][TX1REQ][TX0IF][TX0REQ][RX1IF][RX0IF]
**                          TX?REQ = TXB?CNTRL.TXREQ̃rbgł
*********************************************************************************************************/
uint8_t mcp25xx_readStatus(void)
{
    uint8_t i ;

    MCP25XX_SELECT() ;
    SPI_transfer(MCP_READ_STATUS) ;     // "ԓǂݍ"R}h̔s
    i = SPI_transfer(0x00) ;            // 1񂾂ǂݍ݂܂
    MCP25XX_UNSELECT() ;

    return i ;
}
/*********************************************************************************************************
** Function name:           mcp25xx_readRegister
** Descriptions:            w肵AhX̃WX^lǂݍ݂܂B
** Parameters:    address - ǂݍ݂WX^̃AhXw
** Return Values:           ǂݍ񂾃WX^̓eԂ
*********************************************************************************************************/
uint8_t mcp25xx_readRegister(const uint8_t address)
{
     uint8_t ret;

     MCP25XX_SELECT() ;
     SPI_transfer(MCP_READ) ;      // "WX^Ǎ"R}h̔s
     SPI_transfer(address) ;
     ret = SPI_transfer(0x00) ;
     MCP25XX_UNSELECT() ;

     return ret ;
}
/*********************************************************************************************************
** Function name:           mcp25xx_readRegisterS
** Descriptions:            w肵AhXw肵̃WX^lAœǂݍ݂܂B
** Parameters:    address - ǂݍ݂WX^̐擪AhXw
**                *values - ǂݍ񂾃WX^e̊i[AhXw
**                      n - ǂݍރWX^̌w
** Return Values:           
*********************************************************************************************************/
void mcp25xx_readRegisterS(const uint8_t address, uint8_t values[], const uint8_t n)
{
     uint8_t i;

     MCP25XX_SELECT() ;
     SPI_transfer(MCP_READ) ;      // "WX^Ǎ"R}h̔s
     SPI_transfer(address) ;
     // mcp2515ɂ̓WX^AhX|C^̎CNg܂B
     for (i=0 ; i<n && i<CAN_MAX_CHAR_IN_MESSAGE ; i++) {
          values[i] = SPI_transfer(0x00) ;
     }
     MCP25XX_UNSELECT() ;
}
/*********************************************************************************************************
** Function name:           mcp25xx_setRegister
** Descriptions:            w肵AhX̃WX^Ƀf[^݂܂B
** Parameters:    address - ݂WX^̃AhXw
**                 values - ރWX^ew
** Return Values:           
*********************************************************************************************************/
void mcp25xx_setRegister(const uint8_t address, const uint8_t value)
{
     MCP25XX_SELECT() ;
     SPI_transfer(MCP_WRITE) ;     // "WX^"R}h̔s
     SPI_transfer(address) ;
     SPI_transfer(value) ;
     MCP25XX_UNSELECT() ;
}

/*********************************************************************************************************
** Function name:           mcp25xx_setRegisterS
** Descriptions:            w肵AhX̃WX^Ɏw肵̃f[^݂܂B
** Parameters:    address - ݂WX^̃AhXw
**                *values - ރWX^ei[i[AhXw
**                      n - ރWX^̌w
** Return Values:           
*********************************************************************************************************/
void mcp25xx_setRegisterS(const uint8_t address, const uint8_t values[], const uint8_t n)
{
     uint8_t i;

     MCP25XX_SELECT() ;
     SPI_transfer(MCP_WRITE) ;     // "WX^"R}h̔s
     SPI_transfer(address) ;
     // mcp2515ɂ̓WX^AhX|C^̎CNg܂B
     for (i=0 ; i<n ; i++) {
          SPI_transfer(values[i]) ;
     }
     MCP25XX_UNSELECT();
}
/*********************************************************************************************************
** Function name:           mcp25xx_modifyRegister
** Descriptions:            w肵AhX̃WX^"rbgύX"R}hŏ܂B
*********************************************************************************************************/
void mcp25xx_modifyRegister(const uint8_t address, const uint8_t mask, const uint8_t data)
{
     MCP25XX_SELECT() ;
     SPI_transfer(MCP_BITMOD) ;    // "rbgύX"R}h̔s
     SPI_transfer(address) ;
     SPI_transfer(mask) ;
     SPI_transfer(data) ;
     MCP25XX_UNSELECT() ;
}
/*********************************************************************************************************
** Function name:           mcp25xx_setCANCTRL_Mode
** Descriptions:            CAN䃌WX^(CANCTRL)ɏ݂܂B
*********************************************************************************************************/
uint8_t mcp25xx_setCANCTRL_Mode(const uint8_t newmode)
{
     uint8_t i ;

     mcp25xx_modifyRegister(MCP_CANCTRL, MODE_MASK, newmode) ;   // XV

     i = mcp25xx_readRegister(MCP_CANCTRL) ;                     // ǂݍ
     i &= MODE_MASK ;

     if ( i == newmode ) {
          return MCP25XX_OK ;
     }

     return MCP25XX_FAIL ;
}
/*********************************************************************************************************
** Function name:           mcp_reset
** Descriptions:            foCXZbg܂B
*********************************************************************************************************/
void mcp_reset(void)
{
     MCP25XX_SELECT() ;
     SPI_transfer(MCP_RESET) ;     // "Zbg"R}h̔s
     MCP25XX_UNSELECT() ;
     __delay_ms(10) ;
}
