/***********************************(abc932-18326.c)********
 *		USB-CAN Converter  (MCP25625BOgp)  m[h6B2 *
 ***********************************************************/

//#include "mcc_generated_files/mcc.h"
//#include "mcc_generated_files/examples/i2c1_master_example.h"
#include "myProject.h"
#include "myFunction.h"
#include "mcp_can_dfs.h"
#include "skMCP25xx.h"
#include "i2c_LCD_lib.h"

#define  ADT_ADR  0x48                  // ADT I2CAhX

#define  MBF_SIZE    64                 // bZ[WBFTCY

void CAN_Send(uint32_t id, uint8_t *buf, uint8_t len);


/************************************************************
 *  O[oϐ
 *==========================================================*/
//---- ^C}[p
uint8_t  TFlg;                          // ^C}[tO

//---- EUSARTVAp
char     RBuf[EU_BFSIZE];               // MBuffer
uint8_t  SFlg;                          // MtO
		
//---- ėpf[^p
char     Msg[MBF_SIZE];                 // Rgp
char     Dlm[] = ",";                     // ؂f~^

//---- CANpʕϐ
uint32_t Crv_id = 0x123;                // Mid
char     Crv_Flg = 0 ;                  // CANMLtO
uint8_t  Crv_len = 0 ;                  // CANMf[^TCY
uint8_t  Crv_Buf[8];                    // CANMf[^
char     Crv_Fmt[9] = "SSSSSSSS";       // CANMf[^

uint32_t Csd_id = 0x149;                // Mid
uint8_t  Csd_len = 0 ;                  // CANMf[^TCY
uint8_t  Csd_Buf[8];                    // CANMf[^
char     Csd_Fmt[9] = "SSSSSSSS";       // CANMf[^

//---- xf[^p
uint8_t  Tmp_Snd = 1;                   // xMtO
char     Tmp_Buf[9];                    // ϊ㉷xf[^

/************************************************************
 *  ėp֐ imy_function.cɈȍ~\j
 *==========================================================*/
//--- oCgf[^̌
void swap_b(uint8_t *a, uint8_t *b){
    uint8_t temp;
    temp  = *a;
    *a = *b;
    *b = temp;
}
//--- [hf[^̌
void swap_w(uint16_t *a, uint16_t *b){
    uint16_t temp;
    temp  = *a;
    *a = *b;
    *b = temp;
}
//---- QoCgf[^̏㉺oCgϊ
uint16_t exchg_word(uint16_t wd){
    wd = (wd<<8) | ((uint8_t)(wd>>8));  // ㉺oCgf[^
    return wd;
}
//---- SoCgf[^̏㉺oCgϊ
uint32_t exchg_long(uint32_t Ld){
    union {  uint8_t   b[4];
             uint32_t  L;    } dt ;
    dt.L = Ld;
    swap_b(&dt.b[0], &dt.b[3]);
    swap_b(&dt.b[1], &dt.b[2]);
    return dt.L;
}

/************************************************************
 *  ֌W
 *==========================================================*/
//--- ^C}0 Callback֐ (1b荞)
void TMR0_Process(void){
    TFlg = 1;                           // ^C}[tOZbg
}

//--- ^C}[0@L^؂ւ
void chg_TM0_INT(void){
    Tmp_Snd ^= 1;                         // xM[hύX
    if(Tmp_Snd){       
        PIE0bits.TMR0IE = 1;      // ^C}[L
        EU_Puts("Int_TM0 Enable");
    }else{      
        PIE0bits.TMR0IE = 0;      // ^C}[
        EU_Puts("Int_TM0 Disenable");
    }
}
//----  MCP25625INTs荞
void IOCCF2_Process(void){
     Crv_Flg = 1 ;                     // CANLtOZbg
}

/***********************************************************
 *  xZT[֌W
 *=========================================================*/
//---- xf[^̌vZ
uint16_t calc_Temp(char *bf, uint16_t tDat){
    uint16_t tp;
    if(tDat & 0x8000){                  // Ȃ
        tp = ((8192 - (tDat >> 3)) * 10) / 16;
        sprintf(bf,"-%2d.%1dC", tp / 10, tp % 10);
    }else{                              // Ȃ
        tp = ((tDat >> 3) * 10) / 16;
        sprintf(bf,"%3d.%1dC", tp / 10, tp % 10);
    }
    return tp;
}
//---- xf[^̕\ ----
uint16_t prt_Temp(uint16_t tDat){
    uint16_t  tp;
    sprintf(Msg,"Tmp:%04X",tDat);       // ϊOf[^\
   // --- sprintfgȂꍇ
   // strcmp(Msg,"Tmp:"); my_xtoa(Msg+4,tDat,4);
    EU_Write(Msg);
    LCD_clr(); LCD_str(Msg);            // LCD1sڂɕ\
    tp = calc_Temp(Tmp_Buf, tDat);      // xf[^vZ
    EU_Puts(Tmp_Buf);
    LCD_cursor(1,1); LCD_str(Tmp_Buf);  // LCD2sڂɕ\
    return tp;
}
//--- xf[^̎擾
uint16_t get_ADT7410(void){
    uint16_t temp;
    I2C2_ReadNBytes(ADT_ADR,(uint8_t *)&temp,2); // xf[^Ǎ
    temp = exchg_word(temp);            // ㉺oCgf[^
    prt_Temp(temp);                     // xf[^̕\
    return temp;
}
//--- x`FbNE
void chk_Tmp_Proc(void){
    uint8_t *p;
    if(TFlg){                           // TM0L΁H
        TFlg = 0;                       // TMOtONA
        if(Tmp_Snd){                      // xM[hȂ
            get_ADT7410();              // xf[^捞
            Csd_len = (uint8_t)strlen(Tmp_Buf);
            p = (uint8_t *)Tmp_Buf;
            CAN_Send(0x123, p, Csd_len); // xf[^CANM
        }
    }
}

/************************************************************
 *  MIDݒ
 *      char    *str: ݒpf[^
 *      uint8_t   sr: ID̎ށi0:MA1FMj
 *----------------------------------------------------------*/
void set_NewID(char *str, uint8_t sr){
    uint32_t id;
    id = my_xtol(str);     // Midݒ
    if(id){
        if(sr){
            Crv_id = id;
            sprintf(Msg,"Snd_ID = %3X",Crv_id);
        }else{
            Csd_id = id;
            sprintf(Msg,"Rsv_ID = %3X",Csd_id);
        }
        EU_Puts(Msg);
    }
}

/************************************************************
 *  CANf[^i[
 *      char *fmt:  i[鏑iCrv_Fmt[]/Csd_Fmt[])
 *      char *str:  w蕶iR}؂j
 *----------------------------------------------------------*/
void set_CAN_Fmt(char *fmt, char *str){
    char *ps;                       // ؏o|C^
    uint8_t p = 0;                  // Qƈʒu
    char fch;                       // w蕶
    uint8_t i,j,k,n;
    
    ps = strtok(str,Dlm);           // ̐؂o
    do{
        if(ps==NULL) break;         // 񂪂ȂȂ
        
        fch = (char)toupper(*ps);
        if(strlen(ps) > 1){         // p[^
            j = (uint8_t)atoi(ps+1);         // JԂ
        }else{                        // p[^
            if(fch == 'S') j = 0;   // SŃp͉ϒ
             else          j = 1;
        }

        switch(fch){
            case 'S':           k = j; break;
            case 'U': case 'W': k = 2; break;
            case 'L':           k = 4; break;
            default:            k = 1; break;
        }
 
        if(j)   n = j * k;          // pȂȊȌꍇ
         else   n = 8 - p;          // pȂ̏ꍇ     
        
        if((p + n) > 8) break;      // w蕶I[o[
        
        for(i = 0; i < n; i++){
            fmt[p++] = fch;
        }
        ps = strtok(NULL,Dlm);
    }while(p < 8);                   // 8ȓȂ
    fmt[p] = 0;                     // I
    EU_Puts(fmt);                   // ϊʕ\
}

/***********************************************************
 *  CANM̏
 *---------------------------------------------------------*/
//---- CANMmF
void chk_CANrcv_Proc(void){
    union {  unsigned char c[2] ;
             unsigned int  i ;
          }   data ;
    uint32_t id;

    if(Crv_Flg) {                       // CANM
        Crv_Flg = 0 ;                   // CAN݃tONA
        while (CAN_MSGAVAIL == mcp_checkReceive()) {
            // MbZ[Wǂݍ,
            mcp_readMsgBuf(&Crv_len, (uint8_t *)Crv_Buf);
            // f[^t[Ȃ珈
            if (mcp_isRemoteRequest() == 0) {
                id = (uint32_t)mcp_getCanId() ;
                if(id == Crv_id) {
                        data.c[0] = Crv_Buf[0] ;    // oCg̓
                        data.c[1] = Crv_Buf[1] ;
                        sprintf(Msg,"%03X:%8d",id,data.i);
                    //   --- sprintfgȂꍇ
                    //     my_xtoa(Msg,id,3); Msg[3]=':'; Msg[4]=' ';
                    //     my_utoa(Msg + 5, data.i);
                        EU_Puts(Msg);
                }
            }
        }
    }
}

/************************************************************
 *  CANM̏
 *==========================================================*/
//---- CANM{iWidAMςݑ҂j
/*      uint32_t   id:  11rbgʎq
 *      uint8_t  *buf:  Mf[^AhX
 *      uint8_t   len:  MoCg* 
 *----------------------------------------------------------*/
void CAN_Send(uint32_t id, uint8_t *buf, uint8_t len){
    uint8_t res;
    if(len == 0)
        res = mcp_sendMsgBuf(id,CAN_STDID,CAN_RMTFRM,0,buf,1);
    else
        res = mcp_sendMsgBuf(id,CAN_STDID,CAN_DTFRM,len,buf,1);
}

/*==========================================================
 *  f[^w菑ŕϊoCi[zɒǉ
 *---------------------------------------------------------*/
//---- l@-@1oCgoCi[
uint8_t set_S_B(uint8_t *bf, char *str){
    *bf = (uint8_t)atoi(str);
    return 1;
}
//---- l@-@QoCgoCi[
uint8_t set_S_U(uint8_t *bf, char *str, uint8_t en){
    union {  char       c[2] ;
             uint16_t   u ;     } dt ;
    dt.u = (uint16_t)atoi(str);
    if(en) dt.u = exchg_word(dt.u);     // ㉺oCg
    bf[0] = dt.c[0], bf[1] = dt.c[1];
    return 2;
}
//---- 16i@-@1oCgoCi[
uint8_t set_S_H(uint8_t *bf, char *str){
    *bf = (uint8_t)my_xtol(str);
    return 1;
}
//---- 16i@-@QoCgoCi[
uint8_t set_S_W(uint8_t *bf, char *str, uint8_t en){
    union {  char       c[2] ;
             uint16_t   w ;     } dt ;
    dt.w = (uint16_t)my_xtol(str);
    if(en) dt.w = exchg_word(dt.w);     // ㉺oCg
    bf[0] = dt.c[0], bf[1] = dt.c[1];
    return 2;
}
//---- 16i@-@SoCgoCi[
uint8_t set_S_L(uint8_t *bf, char *str, uint8_t en){
    union {  char       c[4] ;
             uint32_t   L ;
          }   dt ;
    dt.L = my_xtol(str);
    if(en) exchg_long(dt.L);               // ㉺oCg
    bf[0] = dt.c[0], bf[1] = dt.c[1];
    bf[2] = dt.c[2], bf[3] = dt.c[3];
    return 4;
}

/*===========================================================
 *  wɏ]Af[^ϊAobt@[ɒǉ
 *      char      fch:  w蕶
 *      uint8_t   *bf:  i[f[^z(ő8byte)
 *      char     *str:  ϊ镶
 *      uint8_t    sz:  i[of[^TCY
 *  return - ɕϊ(i[jł
 *----------------------------------------------------------*/
uint8_t set_SendData(char fch, uint8_t *bf, char *str, uint8_t sz){
    uint8_t n,i,p;
    p = 8 - sz;
    switch(fch){
        case 'S':                       // 
            n = (uint8_t)strlen(str);
            if(n > sz) n = sz;
            for(i = 0; i < n; i++){     // ő傎
                if(Csd_Fmt[p+i]=='S'){      // w肪'S'Ȃ
                    *bf++ = (uint8_t)*str++; // Rs[
                }else{
                    break;              // 'S'łȂΒf
                }
            }
            n = i;                      // 񂾕
            break;
        case 'C':                       // 1oCg
            *bf = (uint8_t)*str; n = 1;
            break;
        case 'B':                       // l1oCg
            set_S_B(bf, str); n = 1;
            break;
        case 'H':                       // 16i1oCg
            set_S_H(bf, str); n = 1;
            break;
        case 'U':                       // lQoCg
            set_S_U(bf, str, 0); n = 2;
            break;
        case 'W':                       // 16iQoCg
            set_S_W(bf, str, 0); n = 2;
            break;
        case 'L':                       // 16iSoCg
            set_S_L(bf, str, 0); n = 4;
            break;
    }
    return n;
}
/*==========================================================
 *  ؂oAw菑Ńf[^ϊzɊi[
 *      [ QƂ鏑f[^́ACsd_Fmt() ]
 *      uint8_t   *bf:  i[zf[^
 *      char     *str:  ϊ镶
 *  return - ɕϊ(i[jł(s0j
 *---------------------------------------------------------*/
uint8_t set_SdatF(char *bf, char *str){
    char *ps;                           // ؏o|C^
    uint8_t n;                          // ϊEݒσoCg
    uint8_t p = 0;                      // Qƈʒu
    char fch;                           // w蕶

    ps = strtok(str,Dlm);               // ̐؂o
    do{
        if(ps==NULL) break;             // 񂪂Ȃ
        fch = Csd_Fmt[p];               // Ήf[^ʒȕ
        if(fch){
            n = set_SendData(fch,Csd_Buf+p,ps,8-p);
            if(n)   p += n;             // ϊf[^L
             else   break;              // ϊf[^
        }
        else{                           // f[^
            break;
        }
        ps = strtok(NULL,Dlm);          // ̕擾
    }while(p < 8);                      // Lf[^7ȓ
    return p;                           // Lf[^Ԃ
}

/*==========================================================
 *  Mf[^i '~'R}h j 
 *      char *str:  Mw
 *  Return - LMf[^(n=0Ȃ瑗Mf[^j
 *---------------------------------------------------------*/
void CAN_Snd_Cmd(char *str){
    char *ps;
    char cmd;
    uint32_t id;
    uint8_t n;

    if(strlen(RBuf) == 1){              // '~'̂
        EU_Puts(Csd_Fmt);               // ݏ\
        return;
    }
    ps = ++str;                         // *ps͎
    cmd = *ps;
    switch(cmd){
        case 'X': case 'R':
            ps = strtok(ps+1,Dlm);        // ̐؂o
            if(ps!=NULL){               // idw肪
                set_NewID(ps,0);
            }
            if( cmd == 'R')             // [gwȂ
                CAN_Send(Csd_id,Csd_Buf,0); // [gCANM
            break;
        case 'T':
            chg_TM0_INT();              // xM[hύX
            break;
        default:
            set_CAN_Fmt(Csd_Fmt, ps);   // f[^i[
            break;
    }
}

/*==========================================================
 *  Lȃf[^CANM
 *      char *str:  Mf[^
 *      (f[^͎w菑ɏ]AϊđMj
 *---------------------------------------------------------*/
uint8_t CAN_SendData(char *str){
    uint8_t sn = 0;
    uint8_t i;
    char *p;
    
    sn = set_SdatF(Csd_Fmt, str);       // tf[^Zbg
    if(sn){                             // f[^LȂ
        CAN_Send(Csd_id,Csd_Buf,sn);    // CANM{
        sprintf(Msg,"%3X : ",Csd_id);
        
        p = Msg + 6;
        for( i= 0; i<sn; i++){
            my_xtoa(p,Csd_Buf[i],2);
            p+=2;
        }
        *p = 0;
        
        EU_Puts(Msg);
    }
    return sn;
}

/***********************************************************
 *  XCb`ANV
 *---------------------------------------------------------*/
//---- RA3XCb`E`FbNE
void chk_RA3_Proc(void){
    if(IO_RA3_GetValue()==0){           // RA3_SWĂ
        __delay_ms(40);                 // `b^O΍
        if(IO_RA3_GetValue()==0){       // ܂Ă
            chg_TM0_INT();              // xM[hύX
            while(IO_RA3_GetValue() == 0); // L[܂ő҂
        }
        __delay_ms(100);                // `b^O΍
    }
}

//---- SW0iRA0)XCb`E`FbNE
void chk_SW0_Proc(void){
    static uint8_t d[] = { '0',0 };
    if(SW0_GetValue() == 0){            // SW0Ă
        __delay_ms(40);                 // `b^O΍
        if(SW0_GetValue() == 0){        // ܂Ă
            d[0] ^= 1;                  // rbg0𔽓]
            CAN_Send(0x149,d,1);        // f[^1CANM
            while(SW0_GetValue() == 0); // L[܂ő҂
        }
        __delay_ms(100);                // `b^O΍
    }
}

/********************************************************
 *    Main application                                  *
 ********************************************************/
void main(void)
{
    char cmd;
    uint8_t *p, n;
    // initialize the device
    SYSTEM_Initialize();                // VXe
    SSP1CON1bits.SSPEN = 1;             // SPIL
    LCD_init();                         // LCD

    TMR0_SetInterruptHandler(TMR0_Process); // Timer0 Callback֐
    IOCCF2_SetInterruptHandler(IOCCF2_Process);	// PinCallBack

    INTERRUPT_GlobalInterruptEnable();  // ėp
    INTERRUPT_PeripheralInterruptEnable(); // ӊ

    // MCP25625ɂCANʐM̏
    // CANoXʐMx=100Kbps  MCP25625̃NbN=16MHz
    while (CAN_OK != mcp_begin(CAN_100KBPS,MCP_16MHz)) {
        LCD_str("InitFail") ;
        exit(1) ;                       // G[I
    } 
    LCD_str("Init OK!") ;
    LED_SetHigh();
    
    // MASK0->Filter0->RXB0(I[ot[RXB1)̂ݎgp܂B
    mcp_init_Mask(0, 0, 0x3ff);         // SĎt
    mcp_init_Filt(0, 0, Crv_id);        // ID:0x123̂ݎ󂯎

    EU_Puts("- CAN use OK\n");

    while (1){
        chk_Tmp_Proc();                 // xf[^
        chk_RA3_Proc();                 // RA3XCb`
        chk_SW0_Proc();                 // SW0(RA0)XCb`
        chk_CANrcv_Proc();              // CANM

        if(SFlg){                       // VA͗L΁H
//            EU_Puts(RBuf);              // GR[obN

            p = (uint8_t *)RBuf;
            n = (uint8_t)strlen(RBuf) - 1;
            if(n > 8) n = 8;
            cmd = RBuf[0];              // cmd͐擪
            switch(cmd){
                case '~':               // R}h'~'Ȃ
                    CAN_Snd_Cmd(RBuf);    // Mݒ
                    break;
/*
                case '|':               // R}h'|'Ȃ
                    CAN_Rcv_Cmd(RBuf):    // Mݒ
                    break;
*/
                case '^':
                    chg_TM0_INT();      // xM[hύX
                    break; 

                default:
                    CAN_SendData(RBuf); // f[^CANM
                    break;
            }
            SFlg = 0;
       }
    }
}
/*********** end of file ***********************************/
