/*****************************(abc933-18326.c)*******
 *      ȈCANRo[^[                         *
 ****************************************************/
#include "myProject.h"
#include "myFunction.h"
#include "mcp_can_dfs.h"
#include "skMCP25xx.h"
#include "i2c_SSD1306.h"

#define USE_ASC_FONT
#ifdef USE_ASC_FONT
	#include "Font_8x16ASC.h"
#else
	#include "Font_8x16NA.h"
#endif

#define USE_RA3_PORT
#ifdef USE_RA3_PORT 
	#define GET_SW()    RA3_GetValue() 
#else
	#define GET_SW()    SW0_GetValue()  
#endif

#define  MBF_SIZE    64             // bZ[WBFTCY
#define  OLED_SZ     21             // OLEDs\ő啶

char *Md_Msg[] = { "** Integer Mode",
                    "** Ascii Mode",
                    "** HexNum Mode",
                    "** Format Mode"
                  };

/************************************************************
 *  O[oϐ
 *==========================================================*/
//--- ^C}[pϐ
uint8_t  TFlg;                      // ^C}[tO

//---- EUSARTVAp
char RBuf[EU_BFSIZE];               // BFSIZEmyProject.hŐ錾
uint8_t  SFlg;                      // VAMtO

//---- ėpf[^p
char     Msg[MBF_SIZE];             // Rgp
char     Dlm[] = ",";               // ؂f~^

//---- OLED\p
uint8_t  CrtLn = 0;                 // OLED\ݍs
uint8_t  DspMd = 0;                 // f[^\[h
uint8_t  Mx_Ln = 4;                 // ŏIs5s

//---- CANpʕϐ
uint32_t Crv_id = 0x123;            // Mid
uint8_t  Crv_Flg = 0 ;              // CANMLtO
uint8_t  Crv_len = 0 ;              // CANMf[^TCY
uint8_t  Crv_Buf[8];                // CANMf[^
char     Crv_Fmt[9] = "SSSSSSSS";   // CANMf[^

uint32_t Csd_id = 0x149;            // Mid
uint8_t  Csd_len = 0 ;              // CANMf[^TCY
uint8_t  Csd_Buf[8];                // CANMf[^
char     Csd_Fmt[9] = "SSSSSSSS";   // CANMf[^

/*==================================================*
 *  荞݂̏                                  *
 *--------------------------------------------------*/
//--- ^C}0 Callback֐ (1b荞) 
void TMR0_Process(void){
    TFlg = 1;                       // ^C}[tOZbg
}

//----  MCP2515INTs荞
void IOCCF2_Process(void) {
    Crv_Flg = 1;                    // CANM(LjZbg
}

/*==================================================*
 *  OLED\p֐  \eXg֐                *
 *--------------------------------------------------*/
//---- XN[t\i57hbgj
//      (XN[͈͂[0 - Mx_Ln]j
void i2cOLED_Prt(char *str) {
    i2cOLED_posPX(CrtLn, 0);
    i2cOLED_str(str);
    if (CrtLn < Mx_Ln)  CrtLn++;
     else CrtLn = 0;
    i2cOLED_Clr(CrtLn, CrtLn, 0);
}

//---- p\
uint8_t i2cPrint_Hchr(uint8_t py, uint8_t x,char ch){
#ifdef USE_ASC_FONT
    if((0x20 <= ch)&(ch <= 0x7F)){
        x = i2cOLED_Ptn(py,x,2,8,(char *)F_asc[ch-0x20]);
#else
    if((0x30 <= ch)&(ch <= 0x3A)){
        x = i2cOLED_Ptn(py,x,2,8,(char *)F_hn[ch-0x30]);
    }else if((0x41 <= ch)&(ch <= 0x5A)){
        x = i2cOLED_Ptn(py,x,2,8,(char *)F_af[ch-0x41]);
    }else if(ch == 0x20){
        x = i2cOLED_Ptn(py,x,2,8,(char *)F_sp);
    }else if((0x2A <= ch)&(ch <= 0x2F)){
        x = i2cOLED_Ptn(py,x,2,8,(char *)F_op[ch-0x2A]);
    }else if((0x61 <= ch)&(ch <= 0x7A)){
        x = i2cOLED_Ptn(py,x,2,8,(char *)F_af[ch-0x61]);
#endif
    }else{
        x = i2cOLED_Ptn(py,x,2,8,(char *)F_dt);
    }
    return x;
}

//---- p̕\
uint8_t i2cPrint_Hstr(uint8_t py, uint8_t x, char *str) {
    uint8_t n;
    while(*str){
        x = i2cPrint_Hchr(py,x,*str++);
    }
    return x;
}

//----  zf[^16i
void set_hex_data(char *bf, uint8_t *ary, uint8_t n){
    uint8_t i;
    for(i = 0; i < n; i++){
        my_xtoa(bf, ary[i], 2);
        bf += 2;
    }
    *bf = 0;
}

//--- \ȕɕϊĕA
void cv_prtcat(char *bf, char *str, uint8_t n){
    uint8_t i;
    for(i = 0; i < n; i++){
        if(isprint(*str))	*bf++ = *str;
		 else				*bf++ = 0x7F;
				
        str++;
    }
    *bf = 0;
}

//---- OLEDEUɕo
void OLED_EU_Prt(char *str){
     i2cOLED_Prt(str);
     EU_Puts(str);
}

//---- OLED̍ŉsɔp\
void OLED_Low_Hprt(char *str){
    i2cOLED_Clr(6, 7, 0);
    i2cPrint_Hstr(6, 0, str); // p\
}

//----  \[h̕ύX
void chg_dspMd(uint8_t md) {
    if(md > 3) md = 0;
    i2cOLED_Clr(0, 7, 0); CrtLn = 0;
    if(md < 2)      Mx_Ln = 4;
     else           Mx_Ln = 7;
	OLED_EU_Prt(Md_Msg[md]);
    DspMd = md;
}

/************************************************************
 *  MIDݒ
 *      char    *str: ݒpf[^
 *      uint8_t   sr: ID̎ށi0:MA1FMj
 *----------------------------------------------------------*/
void set_NewID(char *str, uint8_t sr){
    uint32_t id;
    id = my_xtol(str);              // id擾
    if(id){
        id &= 0x3FF;                // 11rbg
        if(sr){
            Crv_id = id;            // Midɐݒ
            sprintf(Msg,"Snd_ID = %3X",Crv_id);
        }else{
            Csd_id = id;            // Midɐݒ
            sprintf(Msg,"Rsv_ID = %3X",Csd_id);
        }
        EU_Puts(Msg);
    }
}

/************************************************************
 *  CANf[^i[
 *      char *fmt:  i[鏑iCrv_Fmt[]/Csd_Fmt[])
 *      char *str:  w蕶iR}؂j
 *----------------------------------------------------------*/
void set_CAN_Fmt(char *fmt, char *str){
    char *ps;                           // ؏o|C^
    uint8_t p = 0;                      // Qƈʒu
    char fch;                           // w蕶
    uint8_t i,j,k,n;
    
    ps = strtok(str,Dlm);               // ̐؂o
    do{
        if(ps==NULL) break;             // 񂪂ȂȂ
        
        fch = (char)toupper(*ps);       // 啶
        if(strlen(ps) > 1){             // p[^
            j = (uint8_t)atoi(ps+1);    // JԂ
        }else{                          // p[^
            if(fch == 'S') j = 0;       // SŃp͉ϒ
             else          j = 1;
        }

        switch(fch){
            case 'S':           k = j; break;
            case 'U': case 'W': k = 2; break;
            case 'L':           k = 4; break;
            default:            k = 1; break;
        }
 
        if(j)   n = j * k;              // pȂȊȌꍇ
         else   n = 8 - p;              // pȂ̏ꍇ
        
        if((p + n) > 8) break;          // w蕶I[o[
        
        for(i = 0; i < n; i++){
            fmt[p++] = fch;             // w萔Zbg
        }
        ps = strtok(NULL,Dlm);
    }while(p < 8);                      // 8ȓȂ
    fmt[p] = 0;                         // I
    EU_Puts(fmt);                       // ϊʕ\
}

/*************************************************
 *  CANM
 *================================================
 *  oCi[zw菑ŕɒǉ
 *---------------------------------------------*/
//--- 1oCgoCi[@@liő3j
uint8_t set_B_S(char *str, uint8_t d){
    char s[10];
    sprintf(s,"%d", d);
    strcat(str,s);
    return (uint8_t)strlen(s);
}

//--- QoCgoCi[@@liő5j
uint8_t set_U_S(char *str, uint8_t *bf){
    union {
        uint8_t b[2];
        uint16_t u;     } data;
    char s[10];
    
    data.b[0] = *bf++;
    data.b[1] = *bf;
    sprintf(s,"%d",data.u);    
    strcat(str,s);
    return (uint8_t)strlen(s);    
}

//--- 1oCgoCi[@@16ii2j
uint8_t set_H_S(char *str, uint8_t *h){
    union {
        uint8_t b[2];
        uint16_t w;     } data;
    data.b[0] = *h;
    my_xtoa((char *)str,data.w,2);
    return 2;
}

//--- QoCgoCi[@@16ii4j
uint8_t set_W_S(char *str, uint8_t *bf, uint8_t en){
    union {
        uint8_t b[2];
        uint16_t w;     } data;
    uint8_t i;
    for(i = 0; i < 2; i++)
        data.b[i]= *bf++;  
    if(en) data.w = exchg_word(data.w);
    my_xtoa((char *)str,data.w,4);
    return 4;
}

//--- SoCgoCi[@@16i(6j
uint8_t set_L_S(char *str,uint8_t *bf, uint8_t en){
    union {
        uint8_t b[4];
        uint32_t L;     } data;
    uint16_t h;
    uint8_t i;
    for(i = 0; i < 4; i++)
        data.b[i]= *bf++;
    if(en) data.L = exchg_long(data.L);
    my_xLtoa2((char *)str,data.L,8);
    return 8;
}

/*===========================================================
 *  wɏ]Af[^ϊAobt@[ɒǉ
 *      char     *str:  ϊf[^i[镶
 *      uint8_t   *bf:  ϊ錳f[^z
 *      uint8_t    of:  Af[^QƃItZbgʒu
 *  return - ɕϊ(i[jł
 *----------------------------------------------------------*/
uint8_t set_RecvData(char *str, uint8_t *rbf, uint8_t of){
    char    fch;                        // w蕶
    uint8_t n = 0;                      // i[ϊ
    uint8_t rm;                         // QƎcoCg
    uint8_t i;
    
    fch = Crv_Fmt[of];
    rm = 8 - of;
    switch(fch){                        // EE
        case 'S':                       // ̏ꍇ
            for(i = 0; i < rm; i++){
                if(Crv_Fmt[of+i] == 'S'){ // w肪'S'Ȃ
                    *str++ = (char)*rbf++; // Rs[
                }else{
                    break;              // 'S'łȂΕϊI
                }
            }
            n = i;                      // 񂾕
            break;
            
        case 'C':                       // 1oCg
            if(isprint(*rbf))  *str = *rbf;
             else 			  *str = '*';//0x7F;
            n = 1;
            break;
            
        case 'B':                       // li1-3j
            n = set_B_S(str, *rbf);
            break;
            
        case 'H':                       // 16ii2j
            n = set_H_S(str, rbf);
            break;
            
        case 'U':                       // li1-5j
            n = set_U_S(str, rbf);
            break;
            
        case 'W':                       // 16ii-4j
            n = set_W_S(str, rbf, 1);
            break;
            
        case 'L':                       // 16ii-6j
            n = set_L_S(str, rbf, 1);
            break;
    }
    return n;
}

/*==========================================================
 *  f[^w菑Ńf[^𕶎Ɋi[
 *      [ QƂ鏑f[^́ACrv_Fmt() ]
 *      char     *str:  ϊɊi[镶
 *      uint8_t  *rbf:  ϊzf[^
 *      uint8_t    sz:  Mf[^
 *  return - ɕϊ(i[jł(s0j
 *---------------------------------------------------------*/
uint8_t set_RdatF(char *str, uint8_t *rbf, uint8_t sz){
    uint8_t n = 0;                      // ǉJE^
    uint8_t of = 0;                     // QƃItZbg
    char fch;                           // w蕶
    char ss[20];

//    if(sz < 1) return 0;                // Mf[^Ȃ
    do{
        fch = Crv_Fmt[of];              // Ήf[^ʒȕ
        if(fch){
                if(of>0){                
                    *str = ',';         // ؂ǉ
                    str++;
                }            
//            n = set_RecvData(str,Crv_Buf+of,of);
            n = set_RecvData(str,rbf,of);
//            sprintf(ss,"%c,%d,%d,%x,%x",fch,n,of,rbf[of],Crv_Buf[of]); EU_Puts(ss);

            if(n){                      // ϊf[^L
                switch(fch){            // QƁAϊʒuړ
                    case 'S':
                        of += n; rbf += n;
                        break;
                    case 'C': case 'B': case 'H':
                        of += 1; rbf += 1;
                        break;
                    case 'U': case 'W':
                        of += 2; rbf += 2;
                        break;
                    case 'L':
                        of += 4; rbf += 4;
                        break;
                }
                str += n;               // i[ʒuֈړ
//                rbf += of;
            }else{                      // ϊf[^
                break;                  // [vEo
            }
        }else{                          // f[^
            break;                      // [vEo
        }
        if(of >= sz) break;
    }while(of < 8);                    // Lf[^7ȓ
    *str = 0;
    return of;                          // Lf[^Ԃ
}

/*===================================================*
 *  CANM̏                                    *
 *---------------------------------------------------*/
void CheckReceiveProcess(void) {
    union {
        unsigned char c[2];
        unsigned int i;
        } data;
    unsigned long id;
//    char buf[16];

    // INTs荞݂LΏ
    if (Crv_Flg) {
        Crv_Flg = 0; // 荞݃tONA        
        while (CAN_MSGAVAIL == mcp_checkReceive()) {
            // MbZ[Wǂݍ,
            mcp_readMsgBuf(&Crv_len, Crv_Buf);
            id = mcp_getCanId();
            my_xtoa(Msg, (uint16_t)id, 3);          // id\ݒ 
		        Msg[3] = ':';  Msg[4] = ' ';
            
            // f[^t[Ȃ
            if (mcp_isRemoteRequest() == 0) {
                // idv邩\ϊ[h3Ȃ
                if((id == Crv_id)|(DspMd == 3)){    // w\
                    set_RdatF(Msg+5,Crv_Buf,Crv_len);
                    EU_Puts(Msg);
                    if(strlen(Msg)>OLED_SZ){
                        Msg[OLED_SZ-1] = 0;
                    }
                    i2cOLED_Prt(Msg);
                    
                }else{
                     switch(DspMd){
                        case 0:                     // \
                            data.c[0] = Crv_Buf[0];
                            data.c[1] = Crv_Buf[1];
                            my_utoa(Msg + 5, data.i);
                            OLED_EU_Prt(Msg);
                            OLED_Low_Hprt(Msg);     // p\
                            break;
                        case 1:                     // \ 
                            cv_prtcat(Msg+5, (char *)Crv_Buf, Crv_len);
                            OLED_EU_Prt(Msg);
                            OLED_Low_Hprt(Msg);     // p\
                            break;
                        case 2:                     // 16i\
                            set_hex_data(Msg+5,Crv_Buf,Crv_len);
                            OLED_EU_Prt(Msg);
                            break;
                    }
                }
            }else{                      // [gt[
				Msg[5] = 0;
                strcat(Msg," -- Remote");				
                OLED_EU_Prt(Msg);
                if(DspMd < 2){
                    OLED_Low_Hprt(Msg);     // p\
                }
            }
        }
    }
}

/*==========================================================
 *  Mf[^i '|'R}h j 
 *      char *str:  Mw
 *  Return - Mf[^(n=0Ȃ瑗Mf[^j
 *---------------------------------------------------------*/
void CAN_Rcv_Cmd(char *str){
    char *ps;
    char cmd;
    uint32_t id;
    uint8_t n, m;

    if(strlen(RBuf) == 1){              // '|'̂
        EU_Puts(Crv_Fmt);               // ݏ\
        return;
    }
    ps = ++str;                         // *ps͎
    cmd = (char)toupper(*ps);
    switch(cmd){
        case 'X':
            ps = strtok(ps+1,Dlm);      // ̐؂o
            if(ps!=NULL){               // idw肪
                set_NewID(ps,1);        // MidZbg
            }
            break;
        case 'M':                       // \[hύX
            if(strlen(ps) < 2){        // "|M"2Ȃ
                DspMd++;
                chg_dspMd(DspMd);
            }else{
                m = (uint8_t)atoi(ps+1);
                chg_dspMd(m);
            }
            break;
        default:
            set_CAN_Fmt(Crv_Fmt, ps);   // f[^i[
            break;
    }
}

/************************************************************
 *  CANM̏
 *==========================================================*/
//---- CANM{iWidAMςݑ҂j
/*      uint32_t   id:  11rbgʎq
 *      uint8_t  *buf:  Mf[^AhX
 *      uint8_t   len:  MoCg(len=0Ȃ烊[gj
 *---------------------------------------------------------*/
void CAN_Send(uint32_t id, uint8_t *buf, uint8_t len){
    uint8_t res;
    if(len == 0)
        res = mcp_sendMsgBuf(id,CAN_STDID,CAN_RMTFRM,0,buf,1);
    else
        res = mcp_sendMsgBuf(id,CAN_STDID,CAN_DTFRM,len,buf,1);
}
//--- ő8̕iCsd_idŁjCANM
void CAN_Snd_str(char *buf){
    uint8_t n;
    n = (uint8_t)strlen(buf);
    if(n > 8) n = 8;
    CAN_Send(Csd_id,(uint8_t *)buf,n);    
}

/*==========================================================
 *  f[^w菑ŕϊoCi[zɒǉ
 *---------------------------------------------------------*/
//---- l@-@1oCgoCi[
uint8_t set_S_B(uint8_t *bf, char *str){
    *bf = (uint8_t)atoi(str);
    return 1;
}
//---- l@-@QoCgoCi[
uint8_t set_S_U(uint8_t *bf, char *str, uint8_t en){
    union {  char       c[2] ;
             uint16_t   u ;     } dt ;
    dt.u = (uint16_t)atoi(str);
    if(en) dt.u = exchg_word(dt.u);     // ㉺oCg
    bf[0] = dt.c[0], bf[1] = dt.c[1];
    return 2;
}
//---- 16i@-@1oCgoCi[
uint8_t set_S_H(uint8_t *bf, char *str){
    *bf = (uint8_t)my_xtol(str);
    return 1;
}
//---- 16i@-@QoCgoCi[
uint8_t set_S_W(uint8_t *bf, char *str, uint8_t en){
    union {  char       c[2] ;
             uint16_t   w ;     } dt ;
    dt.w = (uint16_t)my_xtol(str);
    if(en) dt.w = exchg_word(dt.w);     // ㉺oCg
    bf[0] = dt.c[0], bf[1] = dt.c[1];
    return 2;
}
//---- 16i@-@SoCgoCi[
uint8_t set_S_L(uint8_t *bf, char *str, uint8_t en){
    union {  char       c[4] ;
             uint32_t   L ;
          }   dt ;
    dt.L = my_xtol(str);
    if(en) exchg_long(dt.L);               // ㉺oCg
    bf[0] = dt.c[0], bf[1] = dt.c[1];
    bf[2] = dt.c[2], bf[3] = dt.c[3];
    return 4;
}

/*===========================================================
 *  wɏ]Af[^ϊAobt@[ɒǉ
 *      char      fch:  w蕶
 *      uint8_t   *bf:  i[f[^z(ő8byte)
 *      char     *str:  ϊ镶
 *      uint8_t    sz:  i[of[^TCY
 *  return - ɕϊ(i[jł
 *----------------------------------------------------------*/
uint8_t set_SendData(char fch, uint8_t *bf, char *str, uint8_t sz){
    uint8_t n,i,p;
    p = 8 - sz;
    switch(fch){
        case 'S':                       // 
            n = (uint8_t)strlen(str);
            if(n > sz) n = sz;
            for(i = 0; i < n; i++){     // ő傎
                if(Csd_Fmt[p+i]=='S'){  // w肪'S'Ȃ
                    *bf++ = (uint8_t)*str++; // Rs[
                }else{
                    break;              // 'S'łȂΒf
                }
            }
            n = i;                      // 񂾕
            break;
        case 'C':                       // 1oCg
            *bf = (uint8_t)*str; n = 1;
            break;
        case 'B':                       // l1oCg
            set_S_B(bf, str); n = 1;
            break;
        case 'H':                       // 16i1oCg
            set_S_H(bf, str); n = 1;
            break;
        case 'U':                       // lQoCg
            set_S_U(bf, str, 0); n = 2;
            break;
        case 'W':                       // 16iQoCg
            set_S_W(bf, str, 0); n = 2;
            break;
        case 'L':                       // 16iSoCg
            set_S_L(bf, str, 0); n = 4;
            break;
    }
    return n;
}

/*==========================================================
 *  ؂oAw菑Ńf[^ϊzɊi[
 *      [ QƂ鏑f[^́ACsd_Fmt() ]
 *      uint8_t   *bf:  i[zf[^
 *      char     *str:  ϊ镶
 *  return - ɕϊ(i[jł(s0j
 *---------------------------------------------------------*/
uint8_t set_SdatF(char *bf, char *str){
    char *ps;                           // ؏o|C^
    uint8_t n;                          // ϊEݒσoCg
    uint8_t p = 0;                      // Qƈʒu
    char fch;                           // w蕶

    ps = strtok(str,Dlm);               // ̐؂o
    do{
        if(ps==NULL) break;             // 񂪂Ȃ
        fch = Csd_Fmt[p];               // Ήf[^ʒȕ
        if(fch){
            n = set_SendData(fch,Csd_Buf+p,ps,8-p);
            if(n)   p += n;             // ϊf[^L
             else   break;              // ϊf[^
        }
        else{                           // f[^
            break;
        }
        ps = strtok(NULL,Dlm);          // ̕擾
    }while(p < 8);                      // Lf[^7ȓ
    return p;                           // Lf[^Ԃ
}

/*==========================================================
 *  Mf[^i '~'R}h j 
 *      char *str:  Mw
 *  Return - LMf[^(n=0Ȃ瑗Mf[^j
 *---------------------------------------------------------*/
void CAN_Snd_Cmd(char *str){
    char *ps;
    char cmd;
    uint32_t id;
    uint8_t n, m;

    if(strlen(RBuf) == 1){              // '~'̂
        EU_Puts(Csd_Fmt);               // ݏ\
        return;
    }
    ps = ++str;                         // *ps͎
    cmd = (char)toupper(*ps);
    switch(cmd){
        case 'X':  case 'R':
            ps = strtok(ps+1,Dlm);      // ̐؂o
            if(ps!=NULL){               // idw肪
                set_NewID(ps,0);
            }
            if( cmd == 'R')             // [gwȂ
                CAN_Send(Csd_id,Csd_Buf,0); // [gCANM
            break;
        case 'M':                       // \[hύX
            if(strlen(ps) < 2){         // "|M"2Ȃ
                DspMd++;
                chg_dspMd(DspMd);
            }else{
                m = (uint8_t)atoi(ps+1);
                chg_dspMd(m);
            }
            break;
        default:
            set_CAN_Fmt(Csd_Fmt, ps);   // f[^i[
            break;
    }
}

/*==========================================================
 *  Lȃf[^CANM
 *      char *str:  Mf[^
 *      (f[^͎w菑ɏ]AϊđMj
 *---------------------------------------------------------*/
uint8_t CAN_SendData(char *str){
    uint8_t sn = 0;
    uint8_t i;
    char *p;
    
    sn = set_SdatF(Csd_Fmt, str);       // tf[^Zbg
    if(sn){                             // f[^LȂ
        CAN_Send(Csd_id,Csd_Buf,sn);    // CANM{
        sprintf(Msg,"%3X : ",Csd_id);
        p = Msg + 6;
        for( i= 0; i < sn; i++){
            my_xtoa(p,Csd_Buf[i],2);
            p+=2;
        }
        *p = 0;
        EU_Puts(Msg);               // f[^16i
    }
    return sn;
}

/***********************************************************
 *  XCb`ANV
 *---------------------------------------------------------*/
//---- RA3XCb`E`FbNE
void chk_RA3_Proc(void){
    if(RA3_GetValue()==0){           // RA3_SWĂ
        __delay_ms(40);                 // `b^O΍
        if(RA3_GetValue()==0){       // ܂Ă
            chg_dspMd(++DspMd);         
            while(RA3_GetValue() == 0); // L[܂ő҂
        }
        __delay_ms(100);                // `b^O΍
    }
}

//---- SW0iRA0)XCb`E`FbNE
void chk_SW0_Proc(void){
    static uint8_t d[] = { '0',0 };
    if(SW0_GetValue() == 0){            // SW0Ă
        __delay_ms(40);                 // `b^O΍
        if(SW0_GetValue() == 0){        // ܂Ă
            d[0] ^= 1;                  // rbg0𔽓]
            CAN_Send(0x149,d,1);        // f[^1CANM
            while(SW0_GetValue() == 0); // L[܂ő҂
        }
        __delay_ms(100);                // `b^O΍
    }
}

/********************************************************
 *       Main application                               *
 ********************************************************/
void main(void) {
	uint8_t cmd;                    // R}h
	uint8_t buf[8];                 // CANf[^p
	uint8_t sw;                     // XCb`
    char    s[12];
  
    SYSTEM_Initialize();
    SSP1CON1bits.SSPEN = 1;         //SPI1L

    TMR0_SetInterruptHandler(TMR0_Process);     // Timer0 Callback֐
    IOCCF2_SetInterruptHandler(IOCCF2_Process); // PinCallBack

    INTERRUPT_GlobalInterruptEnable();
    INTERRUPT_PeripheralInterruptEnable();


    i2cOLED_init();
    i2cOLED_Clr(0, 7, 0);

    LED_SetHigh();
//    __delay_ms(1000);             // CANW[҂

    EU_Puts("start");
    
    // MCP25625ɂCANʐM̏
    // CANoXʐMx=100Kbps  MCP25625̃NbN=16MHz
    while (CAN_OK != mcp_begin(CAN_100KBPS, MCP_16MHz)) {
        OLED_EU_Prt("InitFail");
        exit(1);                        // G[I
    }
    OLED_EU_Prt("Init OK!");

    // MASK0->Filter0->RXB0(I[ot[RXB1)̂ݎgp
    mcp_init_Mask(0, 0, 0x3ff);         // SĎt
    mcp_init_Filt(0, 0, Crv_id);        // MAllł
    // MCP_PXB_RX_ANYɐݒ肷ƃtB^[͖
  
//    cmd = 63; my_utoa(s,(uint16_t)cmd);
//    sprintf(Msg,"%d:%s",cmd,s); EU_Puts(Msg);
    OLED_EU_Prt("ready!");   
    
    while (1) {
        if(TFlg){                       // ^C}[LH
            TFlg = 0;
            LED_Toggle();               // LED_gO
        }  
       
        chk_RA3_Proc();                 // RA3XCb`
//        chk_SW0_Proc();                 // SW0(RA0)XCb`
        
        CheckReceiveProcess();          // CANMf[^mFE
        
        if (SFlg) { // VA͂
            cmd = RBuf[0];
            switch (cmd) {
                case '~':               // MݒȂ
                    CAN_Snd_Cmd(RBuf);
                    break;
                    
                case '|':               // MݒȂ
                    CAN_Rcv_Cmd(RBuf);
                    break;                   
                    
                case '^':               // R}h'^'Ȃ
                    if(strlen(RBuf)>0)
                        CAN_Snd_str(RBuf+1);    // 񑗐M
                    break; 

                default:
                    CAN_SendData(RBuf); // ϊf[^CANM
                    break;
            }
            SFlg = 0;
        }
    }
}
/*************** End of File **********************/
